/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;

public class ONSDriver
implements Diagnosable {
    static final String CLASS_NAME = ONSDriver.class.getName();
    private static final ONSDriver instance = new ONSDriver();
    private ONS onsObj = null;
    private boolean calledStart = false;
    private boolean isRemote = false;

    public static ONSDriver instance() {
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean start(String string) throws UniversalConnectionPoolException {
        try {
            boolean bl;
            void config;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "start", "entering args ({0})", null, null, string);
            this.calledStart = false;
            this.isRemote = false;
            if (null == config || "".equals(config)) {
                this.isRemote = false;
                this.calledStart = true;
                this.trace(Level.FINE, CLASS_NAME, "start", "use local ONS subscription", null, null, new Object[0]);
                boolean bl2 = true;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "start", "returning {0}", null, null, bl2);
                return bl2;
            }
            this.isRemote = true;
            this.trace(Level.FINEST, CLASS_NAME, "start", "about to start ONS with config: {0}", null, null, config);
            try {
                bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                    final /* synthetic */ String val$config;
                    {
                        this.val$config = string;
                    }

                    @Override
                    public Boolean run() throws UniversalConnectionPoolException {
                        try {
                            ONSDriver.this.onsObj = new ONS(this.val$config.trim());
                            ONSDriver.this.trace(Level.FINEST, CLASS_NAME, "start", "ONS started with config: {0}", null, null, this.val$config);
                            Boolean bl = true;
                            return bl;
                        }
                        catch (ONSException e) {
                            ONSDriver.this.trace(Level.WARNING, CLASS_NAME, "start", "failed to start ONS", null, e, new Object[0]);
                            throw UCPErrorHandler.newUniversalConnectionPoolException(308);
                        }
                        finally {
                            ONSDriver.this.calledStart = true;
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.calledStart = true;
                this.trace(Level.WARNING, CLASS_NAME, "start", "", null, e, new Object[0]);
                throw UCPErrorHandler.newUniversalConnectionPoolException(308);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "start", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    private ONS getONS() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "getONS", "entering args ()", null, null, new Object[0]);
            if (this.calledStart && this.isRemote && this.onsObj == null) {
                throw UCPErrorHandler.newUniversalConnectionPoolException(312);
            }
            ONS oNS = this.onsObj;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "getONS", "returning {0}", null, null, oNS);
            return oNS;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "getONS", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public Subscriber createSubscriber(String string) throws UniversalConnectionPoolException {
        try {
            void subscribeConfig;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "createSubscriber", "entering args ({0})", null, null, string);
            ONS onsObj = this.getONS();
            if (onsObj == null) {
                Subscriber subscriber = new Subscriber((String)subscribeConfig, "", 30000L);
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "createSubscriber", "returning {0}", null, null, subscriber);
                return subscriber;
            }
            Subscriber subscriber = onsObj.createNewSubscriber((String)subscribeConfig, "", 30000L);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "createSubscriber", "returning {0}", null, null, subscriber);
            return subscriber;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.ONSDriver", "createSubscriber", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return DiagnosticsCollectorImpl.getCommon();
    }
}

