/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.Properties;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.jdbc.oracle.ReplayableRACManagerImpl;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPTaskManagerImpl;
import oracle.ucp.util.UCPTimerManagerImpl;

public class RACManagerFactory {
    public static RACManager getRACManager() throws UniversalConnectionPoolException {
        return RACManagerFactory.getRACManager(DiagnosticsCollectorImpl.getCommon());
    }

    public static RACManager getRACManager(Diagnosable disagnosticsCollector) throws UniversalConnectionPoolException {
        return RACManagerFactory.getRACManager(null, null, null, disagnosticsCollector);
    }

    public static RACManager getRACManager(Properties configProperties, Diagnosable disagnosticsCollector) throws UniversalConnectionPoolException {
        return RACManagerFactory.getRACManager(configProperties, null, null, disagnosticsCollector);
    }

    public static RACManager getRACManager(Properties configProperties, TaskManager taskMngr, TimerManager timerMngr) throws UniversalConnectionPoolException {
        return RACManagerFactory.getRACManager(configProperties, taskMngr, timerMngr, DiagnosticsCollectorImpl.getCommon());
    }

    public static RACManager getRACManager(Properties configProperties, TaskManager taskMngr, TimerManager timerMngr, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        String prefix = "oracle.ucp.jdbc.oracle.";
        boolean isReplayable = RACManagerFactory.isTrue(configProperties, "oracle.ucp.jdbc.oracle.Replayable");
        boolean isStrictWSAffinity = RACManagerFactory.isTrue(configProperties, "oracle.ucp.jdbc.oracle.StrictWebSessionAffinity");
        boolean isStrictXAAffinity = RACManagerFactory.isTrue(configProperties, "oracle.ucp.jdbc.oracle.StrictXAAffinity");
        TaskManager taskManager = taskMngr != null ? taskMngr : new UCPTaskManagerImpl();
        TimerManager timerManager = timerMngr != null ? timerMngr : new UCPTimerManagerImpl();
        return isReplayable ? new ReplayableRACManagerImpl(taskManager, timerManager, isStrictWSAffinity, isStrictXAAffinity, diagnosticsCollector) : new RACManagerImpl(taskManager, timerManager, isStrictWSAffinity, isStrictXAAffinity, diagnosticsCollector);
    }

    private static boolean isTrue(Properties props, String key) {
        if (null == props) {
            return false;
        }
        String prop = props.getProperty(key);
        if (null == prop) {
            return false;
        }
        return prop == null ? false : "true".equals(prop.trim().toLowerCase());
    }
}

