/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ucp.proxy.AnnotationsRegistry;
import oracle.ucp.proxy.ClassGenerator;
import oracle.ucp.proxy.MethodSignature;
import oracle.ucp.proxy.ProxyFactory;
import oracle.ucp.proxy.ReadOnlyList;
import oracle.ucp.proxy.Utils;
import oracle.ucp.proxy._Proxy_;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class MethodGenerator {
    private final String methodObject;
    private final String proxyName;
    private final String ifaceName;
    private final String superclassName;
    private final String proxyType;
    private final String ifaceType;
    private final Method method;
    private final ClassGenerator.AnnotationsForIface annotationsForIface;
    private final boolean callDelegate;
    private final boolean returns;
    private final Class<?>[] parameterTypes;
    private final Class<?>[] exceptionTypes;
    private final Class<?> returnType;
    private final String methodName;
    private final String signature;
    private final String[] throwables;
    private final List<Class<?>> exceptionsToCatch = new ReadOnlyList<Class<?>>(){

        @Override
        public Class<?> get(int index) {
            return 0 == index ? RuntimeException.class : MethodGenerator.this.exceptionTypes[index - 1];
        }

        @Override
        public int size() {
            return MethodGenerator.this.exceptionTypes.length + 1;
        }
    };

    MethodGenerator(ClassGenerator classGenerator, Method method, boolean callDelegate, Integer methodId) {
        this.proxyName = classGenerator.getProxyName();
        this.ifaceName = classGenerator.getIfaceName();
        this.superclassName = classGenerator.getSuperclassName();
        this.ifaceType = classGenerator.getIfaceType();
        this.proxyType = classGenerator.getProxyType();
        this.method = method;
        this.annotationsForIface = classGenerator.getAnnotationsForIface();
        this.callDelegate = callDelegate;
        this.parameterTypes = method.getParameterTypes();
        this.exceptionTypes = method.getExceptionTypes();
        this.returnType = method.getReturnType();
        this.returns = !"void".equals(this.returnType.getName());
        this.methodName = method.getName();
        this.signature = Utils.makeSignature(this.parameterTypes, this.returnType);
        this.throwables = Utils.makeThrowables(this.exceptionTypes);
        this.methodObject = "methodObject" + methodId.toString();
    }

    String getMethodObject() {
        return this.methodObject;
    }

    private Method getMethodPre() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        Method methodPre = value.getMethodPre(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        if (null == methodPre) {
            return null;
        }
        this.checkIfThrowablesMatch(methodPre);
        return methodPre;
    }

    private boolean isResultProxied() {
        if (!this.hasAssignableProxyForReturnType(this.returnType, this.annotationsForIface.getRegistry().keySet())) {
            return false;
        }
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return false;
        }
        boolean belongsToIfaceToProxy = value.belongsToIfaceToProxy(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        return belongsToIfaceToProxy && ProxyResultPolicy.MANUAL != this.getProxyResultPolicy();
    }

    private final boolean hasAssignableProxyForReturnType(Class<?> returnType, Set<Class<?>> proxyTypes) {
        for (Class<?> iface : proxyTypes) {
            if (!returnType.isAssignableFrom(iface)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodPreDefined() {
        return null != this.getMethodPre();
    }

    private Method getMethodVoidPost() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        return value.getMethodVoidPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
    }

    private boolean isMethodVoidPostDefined() {
        return null != this.getMethodVoidPost();
    }

    private Method getMethodReturningPost() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        return value.getMethodReturningPost(this.annotationsForIface.getIface(), new MethodSignature(this.method));
    }

    private boolean isMethodReturningPostDefined() {
        return null != this.getMethodReturningPost();
    }

    private Method getMethodVoidOnError(Class<?> exceptionType) {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        Map<Class<?>, Method> voidOnErrorsMap = value.getMapVoidOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        if (null == voidOnErrorsMap) {
            return null;
        }
        return voidOnErrorsMap.get(exceptionType);
    }

    private boolean isMethodVoidOnErrorDefined() {
        boolean flag = false;
        for (Class<?> exceptionType : this.exceptionsToCatch) {
            if (null == this.getMethodVoidOnError(exceptionType)) continue;
            flag = true;
        }
        return flag;
    }

    private Method getMethodReturningOnError(Class<?> exceptionType) {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return null;
        }
        Map<Class<?>, Method> returningOnErrorsMap = value.getMapReturningOnError(this.annotationsForIface.getIface(), new MethodSignature(this.method));
        if (null == returningOnErrorsMap) {
            return null;
        }
        return returningOnErrorsMap.get(exceptionType);
    }

    private boolean isMethodReturningOnErrorDefined() {
        boolean flag = false;
        for (Class<?> exceptionType : this.exceptionsToCatch) {
            if (null == this.getMethodReturningOnError(exceptionType)) continue;
            flag = true;
        }
        return flag;
    }

    private boolean isMethodOnErrorDefined() {
        return this.returns ? this.isMethodReturningOnErrorDefined() : this.isMethodVoidOnErrorDefined();
    }

    private boolean isMethodPostDefined() {
        return this.returns ? this.isMethodReturningPostDefined() : this.isMethodVoidPostDefined();
    }

    final Method getMethodPost() {
        Method methodPost;
        Method method = methodPost = this.returns ? this.getMethodReturningPost() : this.getMethodVoidPost();
        if (null == methodPost) {
            return null;
        }
        this.checkIfThrowablesMatch(methodPost);
        return methodPost;
    }

    private void checkIfThrowablesMatch(Method injectedMethod) {
        Class<?>[] injectedMethodThrowables = injectedMethod.getExceptionTypes();
        Class<?>[] thisMethodThrowables = this.method.getExceptionTypes();
        for (Class<?> injectedMethodThrowable : injectedMethodThrowables) {
            boolean match = false;
            for (Class<?> thisMethodThrowable : thisMethodThrowables) {
                if (!injectedMethodThrowable.equals(thisMethodThrowable)) continue;
                match = true;
                break;
            }
            if (match) continue;
            throw new IllegalStateException("superclassName: " + this.superclassName + ", method: " + this.method + ", Injected method " + injectedMethod + " - throwables mismatch");
        }
    }

    boolean isAnyInterceptorDefined() {
        return this.isMethodPreDefined() || this.isMethodVoidPostDefined() || this.isMethodReturningPostDefined() || this.isMethodVoidOnErrorDefined() || this.isMethodReturningOnErrorDefined();
    }

    ProxyResultPolicy getProxyResultPolicy() {
        AnnotationsRegistry.Value value = this.annotationsForIface.getValue();
        if (null == value) {
            return ProxyResultPolicy.CACHE;
        }
        return value.getProxyResultPolicy(this.method);
    }

    void generate(ClassWriter classWriter) {
        Label[] l_catchBlockEnds;
        Label[] l_catchBlockBegins;
        Label[] l_catchFrames;
        int len;
        MethodVisitor mv = classWriter.visitMethod(this.method.isVarArgs() ? 129 : 1, this.methodName, this.signature, null, this.throwables);
        mv.visitCode();
        Label l_methodBlockBegin = new Label();
        Label l_methodBlockEnd = new Label();
        Label l_tryBlockBegin = new Label();
        Label l_tryBlockEnd = new Label();
        int varIndex = 1;
        for (Class<?> parameterType : this.parameterTypes) {
            varIndex += Utils.varSize(parameterType);
        }
        int exceptionIndex = varIndex;
        if (this.callDelegate && this.isMethodOnErrorDefined()) {
            len = this.exceptionsToCatch.size();
            l_catchFrames = new Label[len];
            for (int i = 0; i < len; ++i) {
                Method methodOnError;
                Class<?> exceptionToCatch = this.exceptionsToCatch.get(i);
                Method method = methodOnError = this.returns ? this.getMethodReturningOnError(exceptionToCatch) : this.getMethodVoidOnError(exceptionToCatch);
                if (null == methodOnError) continue;
                l_catchFrames[i] = new Label();
                mv.visitTryCatchBlock(l_tryBlockBegin, l_tryBlockEnd, l_catchFrames[i], Utils.makeSlashed(this.exceptionsToCatch.get(i)));
            }
        } else {
            l_catchFrames = null;
        }
        mv.visitLabel(l_methodBlockBegin);
        mv.visitLabel(l_tryBlockBegin);
        if (this.callDelegate && this.isMethodPreDefined()) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
            mv.visitVarInsn(25, 0);
            len = this.parameterTypes.length;
            if (this.method.isVarArgs() && 1 == len) {
                mv.visitVarInsn(25, 1);
            } else if (0 == len) {
                mv.visitFieldInsn(178, this.proxyName, "zeroLengthObjectArray", "[Ljava/lang/Object;");
            } else {
                Utils.loadConst(mv, len);
                mv.visitTypeInsn(189, "java/lang/Object");
                int index = 1;
                for (int i = 0; i < len; ++i) {
                    Class<?> parameterType = this.parameterTypes[i];
                    mv.visitInsn(89);
                    Utils.loadConst(mv, i);
                    mv.visitVarInsn(Utils.loadOpcode(parameterType), index);
                    Utils.autoBox(mv, parameterType);
                    mv.visitInsn(83);
                    index += Utils.varSize(parameterType);
                }
            }
            mv.visitMethodInsn(183, this.superclassName, this.getMethodPre().getName(), "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)V", false);
        }
        if (this.callDelegate && this.isMethodPostDefined()) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
        }
        boolean resultProxied = this.isResultProxied();
        if (this.returns && resultProxied) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.proxyName, "proxyFactory", Utils.makeType(ProxyFactory.class.getName()));
        }
        mv.visitVarInsn(25, 0);
        if (this.callDelegate) {
            mv.visitFieldInsn(180, this.proxyName, "delegate", this.ifaceType);
        }
        this.loadDelegateParams(mv);
        mv.visitMethodInsn(this.callDelegate ? 185 : 183, this.callDelegate ? this.ifaceName : this.superclassName, this.methodName, this.signature, this.callDelegate);
        if (this.returns && resultProxied) {
            Utils.cast(mv, this.returnType, Object.class);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.proxyName, "proxyCache", "Ljava/util/Map;");
            mv.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
            ProxyResultPolicy lPRP = this.getProxyResultPolicy();
            mv.visitMethodInsn(182, Utils.makeSlashed(ProxyFactory.class.getName()), switch (lPRP) {
                case ProxyResultPolicy.CREATE -> "proxyForCreate";
                case ProxyResultPolicy.CACHE -> "proxyForCache";
                case ProxyResultPolicy.CREATE_CACHE -> "proxyForCreateCache";
                default -> throw new RuntimeException("invalid ProxyResultPolicy " + lPRP);
            }, "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Map;Ljava/lang/reflect/Method;)Ljava/lang/Object;", false);
        }
        if (this.callDelegate && this.isMethodPostDefined()) {
            if (this.returns) {
                Utils.cast(mv, resultProxied ? Object.class : this.returnType, this.getMethodPost().getParameterTypes()[1]);
            }
            mv.visitMethodInsn(182, this.superclassName, this.getMethodPost().getName(), "(Ljava/lang/reflect/Method;" + (this.returns ? Utils.makeType(this.getMethodPost().getParameterTypes()[1]) : "") + ")" + Utils.makeType(this.getMethodPost().getReturnType()), false);
            if (this.returns) {
                Utils.cast(mv, this.getMethodPost().getReturnType(), this.returnType);
            }
        } else if (this.returns) {
            Utils.cast(mv, resultProxied ? Object.class : this.returnType, this.returnType);
        }
        mv.visitLabel(l_tryBlockEnd);
        mv.visitInsn(Utils.returnOpcode(this.returnType));
        if (this.callDelegate && this.isMethodOnErrorDefined()) {
            int len2 = this.exceptionsToCatch.size();
            l_catchBlockBegins = new Label[len2];
            l_catchBlockEnds = new Label[len2];
            for (int i = 0; i < len2; ++i) {
                Method methodOnError;
                Class<?> exceptionToCatch = this.exceptionsToCatch.get(i);
                Method method = methodOnError = this.returns ? this.getMethodReturningOnError(exceptionToCatch) : this.getMethodVoidOnError(exceptionToCatch);
                if (null == methodOnError) continue;
                mv.visitLabel(l_catchFrames != null ? l_catchFrames[i] : null);
                mv.visitFrame(4, 0, null, 1, new Object[]{Utils.makeSlashed(exceptionToCatch)});
                mv.visitVarInsn(58, exceptionIndex);
                l_catchBlockBegins[i] = new Label();
                mv.visitLabel(l_catchBlockBegins[i]);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
                if (this.returns && this.callDelegate && this.isMethodPostDefined()) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(178, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
                }
                mv.visitVarInsn(25, exceptionIndex);
                mv.visitMethodInsn(182, this.superclassName, methodOnError.getName(), "(Ljava/lang/reflect/Method;" + Utils.makeType(methodOnError.getParameterTypes()[1].getName()) + ")" + Utils.makeType(methodOnError.getReturnType().getName()), false);
                if (this.returns && this.callDelegate && this.isMethodPostDefined()) {
                    Utils.cast(mv, methodOnError.getReturnType(), this.getMethodPost().getParameterTypes()[1]);
                    mv.visitMethodInsn(182, this.superclassName, this.getMethodPost().getName(), "(Ljava/lang/reflect/Method;" + Utils.makeType(this.getMethodPost().getParameterTypes()[1].getName()) + ")" + Utils.makeType(this.getMethodPost().getReturnType().getName()), false);
                    Utils.cast(mv, this.getMethodPost().getReturnType(), this.returnType);
                } else {
                    Utils.cast(mv, methodOnError.getReturnType(), this.returnType);
                }
                mv.visitInsn(Utils.returnOpcode(this.returnType));
                l_catchBlockEnds[i] = new Label();
                mv.visitLabel(l_catchBlockEnds[i]);
            }
        } else {
            l_catchBlockEnds = null;
            l_catchBlockBegins = null;
        }
        mv.visitLabel(l_methodBlockEnd);
        int varIndex2 = 0;
        mv.visitLocalVariable("this", this.proxyType, null, l_methodBlockBegin, l_methodBlockEnd, varIndex2++);
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            mv.visitLocalVariable("arg" + i, Utils.makeType(this.parameterTypes[i]), null, l_methodBlockBegin, l_methodBlockEnd, varIndex2);
            varIndex2 += Utils.varSize(this.parameterTypes[i]);
        }
        if (this.callDelegate && this.isMethodOnErrorDefined()) {
            if (exceptionIndex != varIndex2) {
                throw new RuntimeException("wrong exception index");
            }
            int len3 = this.exceptionsToCatch.size();
            for (int i = 0; i < len3; ++i) {
                Method methodOnError;
                Class<?> exceptionToCatch = this.exceptionsToCatch.get(i);
                Method method = methodOnError = this.returns ? this.getMethodReturningOnError(exceptionToCatch) : this.getMethodVoidOnError(exceptionToCatch);
                if (null == methodOnError) continue;
                mv.visitLocalVariable("e", Utils.makeType(this.exceptionsToCatch.get(i)), null, l_catchBlockBegins != null ? l_catchBlockBegins[i] : null, l_catchBlockEnds != null ? l_catchBlockEnds[i] : null, exceptionIndex);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void loadDelegateParams(MethodVisitor mv) {
        String pn = Utils.makeSlashed(_Proxy_.class.getName());
        int index = 1;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            Class<?> paramType = this.parameterTypes[i];
            String paramTypeName = Utils.makeSlashed(paramType.getName());
            boolean doUnwrap = false;
            block1: for (AnnotationsRegistry.Value value : this.annotationsForIface.getRegistry().values()) {
                for (Class<?> iface : value.getIfacesToProxy()) {
                    if (!paramType.isAssignableFrom(iface)) continue;
                    doUnwrap = true;
                    continue block1;
                }
            }
            if (doUnwrap) {
                mv.visitVarInsn(Utils.loadOpcode(paramType), index);
                mv.visitTypeInsn(193, pn);
                Label l0 = new Label();
                mv.visitJumpInsn(153, l0);
                mv.visitVarInsn(Utils.loadOpcode(paramType), index);
                mv.visitTypeInsn(192, pn);
                mv.visitMethodInsn(185, pn, "_getDelegate_", "()Ljava/lang/Object;", true);
                mv.visitTypeInsn(192, paramTypeName);
                Label l1 = new Label();
                mv.visitJumpInsn(167, l1);
                mv.visitLabel(l0);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(Utils.loadOpcode(paramType), index);
                mv.visitLabel(l1);
                mv.visitFrame(4, 0, null, 1, new Object[]{paramTypeName});
            } else {
                mv.visitVarInsn(Utils.loadOpcode(paramType), index);
            }
            index += Utils.varSize(this.parameterTypes[i]);
        }
    }

    void initializeMethodObject(MethodVisitor mv) {
        int len = this.parameterTypes.length;
        mv.visitLdcInsn((Object)Type.getType((String)Utils.makeType(this.method.getDeclaringClass().getName())));
        mv.visitLdcInsn((Object)this.methodName);
        Utils.loadConst(mv, len);
        mv.visitTypeInsn(189, "java/lang/Class");
        for (int i = 0; i < len; ++i) {
            mv.visitInsn(89);
            Utils.loadConst(mv, i);
            Utils.loadClass(mv, this.parameterTypes[i]);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(182, "java/lang/Class", "getDeclaredMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
        mv.visitFieldInsn(179, this.proxyName, this.getMethodObject(), "Ljava/lang/reflect/Method;");
    }

    public String toString() {
        return this.methodName + this.signature;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof MethodGenerator)) {
            return false;
        }
        return this.toString().equals(((MethodGenerator)obj).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }
}

